<?php

namespace Tests\Feature;

use App\Models\Customer;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class CustomerTest extends TestCase
{
    use RefreshDatabase;

    public function test_customer_crud_operations(): void
    {
        // Create
        $response = $this->postJson('/api/customers', [
            'name' => 'Test Customer',
            'email' => 'test@example.com',
            'phone' => '1234567890'
        ]);

        $response->assertStatus(201);
        $customerId = $response->json('id');

        // Read
        $this->getJson("/api/customers/{$customerId}")
            ->assertStatus(200)
            ->assertJson(['name' => 'Test Customer']);

        // Update
        $this->putJson("/api/customers/{$customerId}", ['name' => 'Updated Name'])
            ->assertStatus(200)
            ->assertJson(['name' => 'Updated Name']);

        // Delete
        $this->deleteJson("/api/customers/{$customerId}")
            ->assertStatus(204);
    }
}
