<?php

use App\Http\Controllers\API\Category\CategoryController;
use App\Http\Controllers\API\ContactController;
use App\Http\Controllers\API\Customer\CustomerController;
use App\Http\Controllers\API\Employee\EmployeeController;
use App\Http\Controllers\API\Employee\PermissionController;
use App\Http\Controllers\API\Employee\RoleController;
use App\Http\Controllers\API\HelpController;
use App\Http\Controllers\API\ProductController;
use App\Http\Controllers\API\SettingController;
use App\Http\Controllers\API\Slider\SliderController;
use App\Http\Controllers\API\Web\ProductController as WebProductController;
use App\Http\Controllers\API\Web\CategoryController as WebCategoryController;
use App\Http\Controllers\Auth\AuthController;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Auth Routes
|--------------------------------------------------------------------------
*/
Route::post('login', [AuthController::class, 'login']);
Route::post('register', [AuthController::class, 'register']);

/*
|--------------------------------------------------------------------------
| Products Routes
|--------------------------------------------------------------------------
*/
Route::prefix('web')->group(function () {
    Route::get('/products', [WebProductController::class, 'index']);
    Route::get('/products/{product}', [WebProductController::class, 'show']);
    Route::get('/sliders', [WebProductController::class, 'sliders']);

    Route::get('/categories', [WebCategoryController::class, 'index']);
    Route::get('/categories/{category}', [WebCategoryController::class, 'show']);
});

Route::middleware(['auth:sanctum'])->group(function () {

      //Role Routes
      Route::apiResource('roles', RoleController::class);

      Route::delete('permissions/delete-all', [PermissionController::class, 'destroyAll']);
      Route::apiResource('permissions', PermissionController::class);


    /*
    |--------------------------------------------------------------------------
    | client Routes
    |--------------------------------------------------------------------------
    */
    Route::delete('customers/delete-all', [CustomerController::class, 'destroyAll']);
    Route::APIResource('customers', CustomerController::class);

    /*
    |---------------------------------------------------------------f-----------
    | employee Routes
    |--------------------------------------------------------------------------
    */
    Route::delete('employees/delete-all', [EmployeeController::class, 'destroyAll']);
    Route::APIResource('employees', EmployeeController::class);

    /*
    |---------------------------------------------------------------f-----------
    | Categories Routes
    |--------------------------------------------------------------------------
    */
    Route::APIResource('categories', CategoryController::class);

    Route::delete('categories/delete-all', [CategoryController::class, 'destroyAll']);
    Route::post('categories/{id}/restore', [CategoryController::class, 'restore']);
    Route::delete('categories/{id}/force-delete', [CategoryController::class, 'forceDelete']);
    Route::delete('categories/force-delete-all', [CategoryController::class, 'forceDeleteAll']);
    Route::post('categories/restore-all', [CategoryController::class, 'restoreAll']);

    /*
    |---------------------------------------------------------------f-----------
    | products Routes
    |--------------------------------------------------------------------------
    */
    Route::delete('products/delete-all', [ProductController::class, 'destroyAll']);
    Route::APIResource('products', ProductController::class);

    /*
    |---------------------------------------------------------------f-----------
    | Sliders Routes
    |--------------------------------------------------------------------------
    */
    Route::APIResource('sliders', SliderController::class);

    Route::delete('sliders/delete-all', [SliderController::class, 'destroyAll']);
    Route::post('sliders/{id}/restore', [SliderController::class, 'restore']);
    Route::delete('sliders/{id}/force-delete', [SliderController::class, 'forceDelete']);
    Route::delete('sliders/force-delete-all', [SliderController::class, 'forceDeleteAll']);
    Route::post('sliders/restore-all', [SliderController::class, 'restoreAll']);

    Route::get('help-models', [HelpController::class, 'models']);
    Route::get('help-enums', [HelpController::class, 'enums']);

    Route::post('contact', [ContactController::class, 'store']);

     /*
    |--------------------------------------------------------------------------
    | Setting Routes
    |--------------------------------------------------------------------------
    */
    Route::get('settings', [SettingController::class, 'index']);
    Route::post('set-settings', [SettingController::class, 'setConfigForUser']);
    Route::post('send-test-mail', [SettingController::class, 'testMailCredentials']);

});
