<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Employee;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $employeeId = Employee::inRandomOrder()->value('id') ?? 1;

        $categories = [
            [
                'name' => ['en' => 'Electronics', 'ar' => 'إلكترونيات'],
                'description' => ['en' => 'Devices and gadgets', 'ar' => 'أجهزة وأدوات'],
                'created_by' => $employeeId,
            ],
            [
                'name' => ['en' => 'Furniture', 'ar' => 'أثاث'],
                'description' => ['en' => 'Home and office furniture', 'ar' => 'أثاث المنزل والمكتب'],
                'created_by' => $employeeId,
            ],
            [
                'name' => ['en' => 'Books', 'ar' => 'كتب'],
                'description' => ['en' => 'Educational and story books', 'ar' => 'كتب تعليمية وقصصية'],
                'created_by' => $employeeId,
            ],
        ];

        foreach ($categories as $data) {
            Category::create($data);
        }
    }
}
