<?php

namespace App\Trait\Global;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

trait ActionByObserver
{
    /**
     * @return void
     */
    public static function bootCreatedByObserver(): void
    {
        static::updating(static function (Model $model) {
            if (empty($model->action_by) && Auth::check()) {
                $model->action_by = Auth::id();
            }
        });
    }
}
