<?php

namespace App\Support\Services\Registration;

class RegisterServiceProviders
{
    /**
     * @return array
     */
    public static function getServiceProviders(): array
    {
        $namespaces = [];
        $appsPath = base_path('Application');
        foreach (array_diff(scandir($appsPath), ['.', '..', '.DS_Store','.gitkeep']) as $app) {
            $providers = str_replace('.php', '', array_diff(scandir(base_path("Application/$app/Providers")), ['.', '..', '.DS_Store']));
            foreach ($providers as $provider) {
                $namespaces[] = (new \ReflectionClass("Application\\$app\\Providers\\$provider"))->getName();
            }
        }
        return $namespaces;
    }
}
