<?php

namespace App\Services\API\Order;

use App\Models\Order;
use App\Models\Product;
use App\Models\OrderItem;
use Illuminate\Support\Facades\DB;
use App\Services\API\Order\StockService;

class OrderService
{
    public function __construct(private StockService $stockService) {}

    public function store(array $orderData): Order
    {

        return DB::transaction(function () use ($orderData) {
            $order = $this->initializeOrder($orderData);
            $this->addItemsToOrder($order, $orderData['products']);
            $this->stockService->updateIngredientsStock($orderData['products']);

            return $order;
        });
    }

    private function initializeOrder(array $orderData): Order
    {

        return Order::create([
            'customer_id' => auth('customer')->id(),
            'total_price' => 0,
        ]);
    }

    private function addItemsToOrder(Order $order, array $products): void
    {
        $totalPrice = 0;

        foreach ($products as $productItem) {
            $product = Product::find($productItem['product_id']);
            $quantity = $productItem['quantity'];
            $itemTotal = $product->price * $quantity;

            OrderItem::create([
                'order_id' => $order->id,
                'product_id' => $product->id,
                'quantity' => $quantity,
                'unit_price' => $product->price,
            ]);

            $totalPrice += $itemTotal;
        }

        $order->update(['total_price' => $totalPrice]);
    }
}
