<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\OrderItem;

class ProductBelongsToOrder implements Rule
{
    protected $orderId;

    public function __construct($orderId)
    {
        $this->orderId = $orderId;
    }

    public function passes($attribute, $productId)
    {
        // Check if the product_id exists in the order_items table for the given order_id
        return OrderItem::where('order_id', $this->orderId)
            ->where('product_id', $productId)
            ->exists();
    }

    public function message()
    {
        return 'The selected product does not belong to this order.';
    }
}
