<?php

namespace App\Models;

use App\Services\Global\UploadService;
use App\Trait\Global\CreatedByObserver;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class Slider extends Model
{
    use HasFactory, HasTranslations, SoftDeletes, CreatedByObserver;

    protected $fillable = [
        'title',
        'description',
        'image',
        'created_by',
    ];

    public array $translatable = ['title', 'description'];
    public bool $inPermission = true;

    public function image(): Attribute
    {
        return Attribute::make(
            get: static fn($value) => UploadService::url($value),
            set: static fn($value) => UploadService::store($value, 'sliders')
        );
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(Employee::class, 'created_by');
    }
}
