<?php

namespace App\Models;

use Laravel\Sanctum\HasApiTokens;
use App\Services\Global\UploadService;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Customer extends Authenticatable
{
    use HasFactory, HasApiTokens, SoftDeletes, HasRoles;

    public bool $inPermission = true;
    protected $guard = 'client';

    protected $fillable = ['name', 'email', 'password', 'phone'];

    protected $hidden = ['password', 'remember_token'];

    protected function casts(): array
    {
        return [
            'password' => 'hashed',
        ];
    }

    public function files(): MorphMany
    {
        return $this->morphMany(File::class, 'fileable');
    }
    public function logs(): MorphMany
    {
        return $this->morphMany(Log::class, 'loggable');
    }
    public function syncFiles(array $files, $is_update = false): void
    {
        if ($is_update) {
            $this->files()->delete();
        }

        $this->files()->createMany(
            collect($files)
                ->map(
                    fn($file) => [
                        'name' => $file->getClientOriginalName(),
                        'path' => UploadService::store($file, 'client'),
                    ],
                )
                ->toArray(),
        );
    }

    /**
     * relations
    */

    public function orders(): HasMany
    {
        return $this->hasMany(Order::class);
    }

}