<?php
// app/Mail/IngredientLowStockAlert.php
namespace App\Mail;

use App\Models\Ingredient;
use Illuminate\Mail\Mailable;

class IngredientLowStockAlert extends Mailable
{
    public function __construct(public Ingredient $ingredient) {}

    public function build()
    {
        $percentage = ($this->ingredient->current_stock / $this->ingredient->initial_stock) * 100;

        return $this->markdown('emails.ingredient_low_stock')
            ->subject("Low Stock Alert: {$this->ingredient->name}")
            ->with([
                'ingredient' => $this->ingredient,
                'percentage' => round($percentage, 2),
            ]);
    }
}