<?php

namespace App\Listeners;

use App\Events\IngredientStockLow;
use App\Mail\IngredientLowStockAlert;
use App\Models\Customer;
use Illuminate\Support\Facades\Mail;

class SendLowStockNotification
{
    public function handle(IngredientStockLow $event): void
    {
        $customer = Customer::find(auth('customer')->id());
        Mail::to($customer->email)
        ->send(new IngredientLowStockAlert($event->ingredient));
    }
}