<?php

namespace App\Http\Resources\API;

use App\Http\Resources\API\Category\CategoryResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->getTranslations('name'),
            'translation_name' => $this->name,
            'description' => $this->getTranslations('description'),
            'translation_description' => $this->description,
            'files' => $this->files->map(function ($file) {
                return [
                    'id' => $file->id,
                    'name' => $file->name,
                    'url' => asset('storage/' . $file->path),
                ];
            }),
            'category' => $this->whenLoaded('category', fn() => new CategoryResource($this->category), ['id' => $this->category_id]),

            'created_at' => $this->created_at?->toDateTimeString(),
            'updated_at' => $this->updated_at?->toDateTimeString(),
        ];
    }
}
