<?php

namespace App\Http\Resources\API\Order;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PaymentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'payment_method' => $this->payment_method,
            'display_payment_method' => __("enums.payment_method.{$this->payment_method}"),
            'payment_status' => $this->payment_status,
            'display_payment_status' => __("enums.payment_status.{$this->payment_status}"),

            'amount' => $this->amount,
            'transaction_id' => $this->transaction_id,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s'),
        ];
    }
}
