<?php

namespace App\Http\Resources\API\Order;

use Illuminate\Http\Request;
use App\Http\Resources\API\ClientResource;
use App\Http\Resources\API\EmployeeResource;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderNoteHistoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'order_id' => $this->order_id,
            'note' => $this->note,
            'type' => $this->type,
            'sender_type' => $this->sender_type,
            'sender' =>   $this->sender_id,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }
}
