<?php

namespace App\Http\Resources\API\Category;

use App\Http\Resources\API\ProductResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->getTranslations('name'),
            'translation_name' => $this->name,
            'description' => $this->getTranslations('description'),
            'translation_description' => $this->description,
            'image' => $this->image,
            'products' => $this->whenLoaded('products', fn() => ProductResource::collection($this->products), ['id' => $this->id]),
            'created_at' => $this->created_at?->toDateTimeString(),
            'updated_at' => $this->updated_at?->toDateTimeString(),
        ];
    }
}
