<?php

namespace App\Http\Requests\Global;

use Illuminate\Foundation\Http\FormRequest;

class CheckSendingMailRequest extends FormRequest
{

    public function rules(): array
    {
        return [
            'email' => 'required|email|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/',
            'body' => 'required|string',
        ];
    }
}
