<?php

namespace App\Http\Requests\API\Category;

use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name.ar' => ['required', Rule::unique('categories', 'name->ar')->whereNull('deleted_at')->ignore($this->route('category'))],
            'name.en' => ['nullable', Rule::unique('categories', 'name->en')->whereNull('deleted_at')->ignore($this->route('category'))],
            'image' => 'nullable',
            'description.ar' => ['nullable'],
            'description.en' => ['nullable'],
        ];
    }
}
