<?php

namespace App\Http\Controllers\API;

use App\Mail\BasicMail;
use App\Models\Setting;
use App\Filters\KeyFilter;
use App\Filters\GroupFilter;
use Illuminate\Http\JsonResponse;
use Illuminate\Pipeline\Pipeline;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Services\Global\UploadService;
use App\Http\Requests\Global\SettingRequest;
use Illuminate\Routing\Controllers\Middleware;
use Illuminate\Routing\Controllers\HasMiddleware;
use Spatie\Permission\Middleware\PermissionMiddleware;
use App\Http\Requests\Global\Setting\TestCredentialsRequest;

class SettingController extends Controller implements HasMiddleware
{
    public static function middleware()
    {
        // return [
        //     new Middleware(PermissionMiddleware::using('read-setting'), only: ['index']),
        //     new Middleware(PermissionMiddleware::using('update-setting'), only: ['setConfigForUser']),
        // ];
    }

    /**
     * @return JsonResponse
     */
    public function index(): JsonResponse
    {
        $query = app(Pipeline::class)
            ->send(Setting::query())
            ->through([KeyFilter::class, GroupFilter::class])
            ->thenReturn();

        return successResponse($query->get()->groupBy('group'));
    }

    /**
     * @param SettingRequest $request
     * @return JsonResponse
     */
    public function setConfigForUser(SettingRequest $request): JsonResponse
    {
        foreach ($request->settings as $item) {
            $value = !empty($item['value']) ? $item['value'] : null;

            if ($value && is_file($value)) {
                $value = UploadService::store($item['value'], 'settings');
            }

            $setting = Setting::updateOrCreate([
                'key' => $item['key'],
                'group' => $item['group']
            ], [
                'value' => $value
            ]);

            if ($setting->is_env) {
                updateDotEnv([strtoupper($item['key']) => $value]);
            }
        }

        return successResponse(msg: __('api.updated_success'));
    }

    /**
     * @param TestCredentialsRequest $request
     * @return JsonResponse
     */
    // public function testMailCredentials(TestCredentialsRequest $request): JsonResponse
    // {
    //     Mail::to($request->email)->send(new BasicMail(null, [
    //         'title' => 'test_credentials',
    //         'mailMsg' => $request->body
    //     ]));

    //     return successResponse(msg: __('api.test_credentials_success'));
    // }
}
