<?php

namespace App\Http\Controllers\API\Order;


use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Services\API\Order\OrderService;
use App\Http\Requests\API\Order\OrderRequest;


class OrderController extends Controller
{
    public function __construct(private OrderService $orderService) {}

    public function store(OrderRequest $request): JsonResponse
    {
        $order = $this->orderService->store($request->validated());

        return response()->json([
            'message' => 'Order created successfully',
            'order' => $order,
        ], 201);
    }
}