<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Http\Requests\API\ContactUsRequest;
use App\Http\Resources\API\ContactUsResource;
use App\Models\ContactUs;

class ContactController extends Controller
{
    public function store(ContactUsRequest $request): JsonResponse
    {
        $contactRequest = ContactUs::create($request->validated());
        return successResponse(new ContactUsResource($contactRequest), __('api.created_success'));

    }
}
