<?php

namespace App\Filters\Global;

use Closure;

class JsonNameFilter
{
    public function handle($request, Closure $next)
    {
        $query = $next($request);

        $languages = config('app.supported_languages') ?? ['ar', 'en'];

        $query->when(request()?->has('term') && !empty(request('term')), function ($q) use ($languages) {
            $search = request('term');
            $q->where(function ($q) use ($languages, $search) {
                foreach ($languages as $language) {
                    $q->orWhereRaw("JSON_EXTRACT(name, '$.$language') LIKE ?", ["%$search%"]);
                }
            });
        });


        return $query;
    }
}